 ; This is flaky - the version in Inc is used instead.
 ; This is saved in case it turns out to be necessary to increment strings with
 ; decimals.

 ; Ŀ
 ;   Linc - increment the last character in a string.                      
 ;   Ldec - decrement the last character in a string.                      
 ;   Copyright 2007 by Rocket Software Ltd.                                
 ;   A routine that has been missing.                                      
 ; 

 ; Ŀ
 ;   Subroutine Deco - count decimal places at the end of number string.   
 ;   Calls nothing.                                                        
 ;   Arguments: Str, a string.                                             
 ;   Returns a number, or nil if the string wasn't a number or if no       
 ;   decimal point was found.                                              
 ; 
 (DEFUN DECO (str / len pos char subnum stra stop)
  (setq pos (setq len (strlen str)))
  (while (and (null stop) (>= pos 1)
              (setq char (substr str pos 1))
              (or (= char ".")
                  (= (type (read char)) 'INT)))
         (if (= char ".")
             (setq stop pos)
             (setq pos (1- pos))))
 (if stop (setq stop (- len stop)))
 stop)
 ; Ŀ
 ;   Subroutine Deco end.                                                  
 ; 

 ; Ŀ
 ;   Subroutine Dezo - restore a number string back to a certain number    
 ;   of decimal places.                                                    
 ;   Calls Deco to count the existing spaces.                              
 ;   Arguments: Str, a string.                                             
 ;              Num, the desired number of decimals.                       
 ;   Returns the string, possibly modified.                                
 ; 
 (DEFUN DEZO (str num / strsav decis difa len)
  (setq strsav str)
  (if (setq decis (deco str))
 ; Ŀ
 ;   If the number of decimal places to remove is > 0.                     
 ; 
      (cond ((> (setq difa (- decis num)) 0)
             (setq str (substr str 1 (- (strlen str) difa))))
 ; Ŀ
 ;   If the number of decimal places to remove is < 0.                     
 ; 
            ((< difa 0)
             (repeat (abs difa)
                     (setq str (strcat str "0"))))))
 ; Ŀ
 ;   If the string has changed and the last character is a decimal point   
 ;   then remove it.                                                       
 ; 
  (if (and (/= strsav str)
           (= (substr str (setq len (strlen str)) 1) "."))
      (setq str (substr str 1 (1- (strlen str)))))
 str)
 ; Ŀ
 ;   Subroutine Dezo end.                                                  
 ; 

 ; Ŀ
 ;   Subroutine link: increment or decrement a string depending on the     
 ;   value of the sole attribute, idec.                                    
 ; 
 (DEFUN LINK (idec / *error* snapp nent prom enam entt typ asoc1 txt outer)
  (command ".undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make a nice local error handler.                                      
 ; 
  (defun *error* (shk /)
   (prompt shk)
   (setvar "snapmode" snapp)
   (command ".undo" "end")
  (princ))
 ; Ŀ
 ;   Ask for an entity to increment or decrement.                          
 ; 
  (setq prom (if idec "in" "de"))
  (setq enam (car (setq nent (nentsel (strcat "\nEntity to " prom
                                              "crement: ")))))
  (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
  (if (or (= "TEXT" typ) (= "MTEXT" typ) (= "ATTDEF" typ) (= "ATTRIB" typ))
      (progn
           (setq outer (car (reverse (car (reverse nent)))))
           (setq txt (cdr (setq asoc1 (assoc 1 entt))))
 ; Ŀ
 ;   Call Ndec to increment or decrement the string.                       
 ; 
           (setq txt (ndec txt idec))
           (entmod (subst (cons 1 txt) asoc1 entt))
           (entupd enam)
           (if (= (type outer) 'ENAME) (entupd outer))))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (setvar "snapmode" snapp)
  (command ".undo" "end")
 (princ))
 ; Ŀ
 ;   Link end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Ndec - increment or decrement the last clump of numbers    
 ;   in a string if they are right at the end.                             
 ;   Calls nothing.                                                        
 ;   Arguments: Str, a string.                                             
 ;              Idec, Increment (T) or decrement ().                       
 ;   Returns the possibly modifed string.                                  
 ;   (ndec "") returns "", (ndec "a") returns "a".                         
 ;   Note that incrementing or decrementing reals through zero is a        
 ;   problem: does 0.1 decrement to -1.1 or to -0.9?  Similarly does       
 ;   -0.2 increment to 0.8, or to 1.2?                                     
 ;   Ndec uses the correct mathematical approach, not wanting to make      
 ;   assumptions about what the user might be trying to do.                
 ; 
 (DEFUN NDEC (str idec / places pos char subnum stra)
  (setq places (deco str))        ; save the number of decimal places.
 ; Ŀ
 ;   Split the string into a main string and the trailing number           
 ;   substring.                                                            
 ; 
  (setq pos (strlen str))
  (while (and (>= pos 1)
              (setq char (substr str pos 1))
              (or (member char '("-" "."))
                  (= (type (read char)) 'INT)))
         (setq pos (1- pos)))
  (setq subnum (substr str (1+ pos)))
  (setq stra (substr str 1 pos))
 ; Ŀ
 ;   If the number substring contains leading zeroes, except for one       
 ;   immediately before a decimal place, move them onto the main string.   
 ;   For example, "Aaa" "002.1" becomes "Aaa00" "2.1",                     
 ;   but "Aaa" "00.1" becomes "Aaa0" "0.1".                                
 ; 
  (while (and (= (substr subnum 1 1) "0")
              (/= (substr subnum 2 1) ".")
              (/= subnum "0"))
         (setq subnum (substr subnum 2))
         (setq stra (strcat stra "0")))
 ; Ŀ
 ;   Increment the trailing number substring, reassemble the string.       
 ; 
  (setq typ (type (read subnum)))
  (if (/= subnum "")
      (if idec
          (if (= typ 'INT)
              (setq str (strcat stra (itoa (1+ (read subnum)))))
              (progn
                   (setq subnum (rtos (1+ (read subnum))))
 ; Ŀ
 ;   Note than (rtos 0.1) returns ".1", which must be allowed for.         
 ;   Also (rtos -0.1) returns "-.1" ...                                    
 ; 
                   (cond ((= (substr subnum 1 1) ".")
                          (setq subnum (strcat "0" subnum)))
                         ((= (substr subnum 1 2) "-.")
                          (setq subnum (strcat "-0" (substr subnum 2)))))
                   (setq str (strcat stra subnum))))
          (if (= typ 'INT)
              (setq str (strcat stra (itoa (1- (read subnum)))))
              (progn
                   (setq subnum (rtos (1- (read subnum))))
                   (cond ((= (substr subnum 1 1) ".")
                          (setq subnum (strcat "0" subnum)))
                         ((= (substr subnum 1 2) "-.")
                          (setq subnum (strcat "-0" (substr subnum 2)))))
                   (setq str (strcat stra subnum))))))
 ; Ŀ
 ;   Restore the original number of decimal places.                        
 ; 
  (if places (setq str (dezo str places)))
 str)
 ; Ŀ
 ;   Subroutine Ndec end.                                                  
 ; 

 ; Ŀ
 ;   Linc.                                                                 
 ; 
 (DEFUN C:LINC ()
  (link t)
 (princ))

 ; Ŀ
 ;   Ldec.                                                                 
 ; 
 (DEFUN C:LDEC ()
  (link ())
 (princ))

(princ)